/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.compat.sodium_compatibility;

import net.caffeinemc.mods.sodium.client.render.SodiumWorldRenderer;
import net.caffeinemc.mods.sodium.client.render.chunk.RenderSectionManager;
import net.caffeinemc.mods.sodium.client.render.chunk.map.ChunkTrackerHolder;
import net.caffeinemc.mods.sodium.client.render.texture.SpriteUtil;
import net.caffeinemc.mods.sodium.client.world.LevelRendererExtension;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1058;
import net.minecraft.class_310;
import net.minecraft.class_638;
import org.jetbrains.annotations.Nullable;
import qouteall.imm_ptl.core.compat.mixin.sodium.IESodiumWorldRenderer;
import qouteall.imm_ptl.core.compat.sodium_compatibility.IESodiumRenderSectionManager;
import qouteall.imm_ptl.core.compat.sodium_compatibility.SodiumRenderingContext;
import qouteall.imm_ptl.core.render.FrustumCuller;

@Environment(value=EnvType.CLIENT)
public class SodiumInterface {
    @Nullable
    public static FrustumCuller frustumCuller = null;
    public static Invoker invoker = new Invoker();

    public static class Invoker {
        public boolean isSodiumPresent() {
            return false;
        }

        public Object createNewContext(int renderDistance) {
            return null;
        }

        public void switchContextWithCurrentWorldRenderer(Object context) {
        }

        public void markSpriteActive(class_1058 sprite) {
        }

        public void onClientChunkLoaded(class_638 world, int chunkX, int chunkZ) {
        }

        public void onClientChunkUnloaded(class_638 world, int chunkX, int chunkZ) {
        }
    }

    public static class OnSodiumPresent
    extends Invoker {
        @Override
        public boolean isSodiumPresent() {
            return true;
        }

        @Override
        public Object createNewContext(int renderDistance) {
            return new SodiumRenderingContext(renderDistance);
        }

        @Override
        public void switchContextWithCurrentWorldRenderer(Object context) {
            SodiumWorldRenderer swr = ((LevelRendererExtension)class_310.method_1551().field_1769).sodium$getWorldRenderer();
            swr.scheduleTerrainUpdate();
            RenderSectionManager renderSectionManager = ((IESodiumWorldRenderer)swr).ip_getRenderSectionManager();
            ((IESodiumRenderSectionManager)renderSectionManager).ip_swapContext((SodiumRenderingContext)context);
            swr.scheduleTerrainUpdate();
        }

        @Override
        public void markSpriteActive(class_1058 sprite) {
            SpriteUtil.markSpriteActive((class_1058)sprite);
        }

        @Override
        public void onClientChunkLoaded(class_638 world, int chunkX, int chunkZ) {
            ChunkTrackerHolder.get((class_638)world).onChunkStatusAdded(chunkX, chunkZ, 1);
        }

        @Override
        public void onClientChunkUnloaded(class_638 world, int chunkX, int chunkZ) {
            ChunkTrackerHolder.get((class_638)world).onChunkStatusRemoved(chunkX, chunkZ, 1);
        }
    }
}

